Utils.ViewPort=new Object();
Utils.ViewPort.getBrowserVersion=function(){
	if(typeof window.innerWidth != 'undefined'){
		return 0;
	}
	else if(
		typeof document.documentElement != 'undefined' &&
		typeof document.documentElement.clientWidth != 'undefined' &&
		document.documentElement.clientWidth != 0
	){
		return 1;
	}
	else{
		return 2;
	}
}

Utils.ViewPort.getScroll=function(){
	var scrollX=0;
	var scrollY=0;
	if(typeof(window.pageYOffset)=='number'){
		scrollY=window.pageYOffset;
		scrollX=window.pageXOffset;
	}
	else if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){
		scrollY=document.body.scrollTop;
		scrollX=document.body.scrollLeft;
	}
	else if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){
		scrollY=document.documentElement.scrollTop;
		scrollX=document.documentElement.scrollLeft;
	}
	else{
		return new Array(0,0);
	}
	return new Array(scrollX,scrollY);
}

Utils.ViewPort.get=function(){
	switch(Utils.ViewPort.getBrowserVersion()){
		case 0:
			return new Array(window.innerWidth,window.innerHeight);
			break;
		case 1:
			return new Array(document.documentElement.clientWidth,document.documentElement.clientHeight);
			break;
		case 2:
			return new Array(document.getElementsByTagName('body')[0].clientWidth,document.getElementsByTagName('body')[0].clientHeight);
			break;
	}
}

Utils.ViewPort.set=function(Width,Height){
	switch(Utils.ViewPort.getBrowserVersion()){
		case 0:
			window.innerWidth=Width;
			window.innerHeight=Height;
			break;
		case 1:
			document.documentElement.clientWidth=Width;
			document.documentElement.clientHeight=Height;
			break;
		case 2:
			document.getElementsByTagName('body')[0].clientWidth=Width;
			document.getElementsByTagName('body')[0].clientHeight=Height;
			break;
	}
}